/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.role.IRoleFollower;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerGameData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.util.Util;

public class RoleFollower
extends RoleInterface
implements IRoleFollower {
    public boolean disableGui = false;
    public boolean infiniteDays = false;
    public boolean isFollowing = true;
    public boolean refuseSoulStone = false;
    public int daysHired;
    public String dialogFarewell;
    public String dialogHire = new TextComponentTranslation("follower.hireText", new Object[0]).func_150254_d() + " {days} " + new TextComponentTranslation("follower.days", new Object[0]).func_150254_d();
    public String dialogFired;
    public String ownerUUID;
    public long hiredTime;
    public long waitTime;
    public int rentalMoney = 0;
    public NpcMiscInventory rentalItems;
    public NpcMiscInventory inventory;
    public EntityPlayer owner = null;
    public HashMap<Integer, Integer> rates;

    public RoleFollower(EntityNPCInterface npc) {
        super(npc);
        this.dialogFarewell = new TextComponentTranslation("follower.farewellText", new Object[0]).func_150254_d() + " {player}";
        this.dialogFired = new TextComponentTranslation("follower.firedText", new Object[0]).func_150254_d() + " {player}";
        this.rentalItems = new NpcMiscInventory(3);
        this.inventory = new NpcMiscInventory(0);
        this.rates = new HashMap();
        this.type = RoleType.FOLLOWER;
        this.waitTime = 0L;
    }

    @Override
    public void addDays(int days) {
        if (this.hiredTime == 0L) {
            this.daysHired = days;
            this.hiredTime = System.currentTimeMillis();
        } else {
            this.daysHired += days;
        }
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.npc.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if ((this.ownerUUID == null || this.ownerUUID.isEmpty()) && this.npc.field_70170_p.field_73011_w.getDimension() != this.npc.homeDimensionId) {
            try {
                Util.instance.teleportEntity(this.npc.field_70170_p.func_73046_m(), (Entity)this.npc, this.npc.homeDimensionId, this.npc.getStartXPos(), this.npc.getStartYPos(), this.npc.getStartZPos());
            }
            catch (CommandException e) {
                LogWriter.error((Object)e);
            }
            return false;
        }
        PlayerData plData = this.getOwnerData();
        if (plData == null) {
            if (this.ownerUUID != null && !this.ownerUUID.isEmpty()) {
                this.killed();
            }
            return false;
        }
        PlayerGameData.FollowerSet fs = plData.game.getFollower(this.npc);
        if (fs == null) {
            fs = plData.game.addFollower(this.npc);
        }
        fs.dimId = this.npc.field_70170_p.field_73011_w.getDimension();
        fs.npc = this.npc;
        this.owner = this.getOwner();
        if (!this.infiniteDays && System.currentTimeMillis() - this.hiredTime > (long)this.getDays() * 1440000L) {
            RoleEvent.FollowerFinishedEvent event = new RoleEvent.FollowerFinishedEvent(this.owner, this.npc.wrappedNPC);
            EventHooks.onNPCRole(this.npc, event);
            if (this.owner != null) {
                if (this.owner.field_71070_bA instanceof ContainerNPCFollowerHire) {
                    this.owner.func_71053_j();
                }
                this.owner.func_145747_a((ITextComponent)new TextComponentTranslation(NoppesStringUtils.formatText(this.dialogFarewell, new Object[]{this.owner, this.npc}), new Object[0]));
            }
            plData.game.removeFollower(this.npc);
            this.killed();
        }
        if (this.npc.func_70638_az() != null) {
            return false;
        }
        if (!this.isFollowing) {
            if (!this.npc.func_70661_as().func_75500_f()) {
                this.npc.func_70661_as().func_75499_g();
            }
            return false;
        }
        if (this.owner == null) {
            return false;
        }
        double dist = this.npc.func_70032_d((Entity)this.owner);
        if (this.owner.field_70170_p.field_73011_w.getDimension() != this.npc.field_70170_p.field_73011_w.getDimension()) {
            try {
                Entity entity = Util.instance.teleportEntity(this.npc.field_70170_p.func_73046_m(), (Entity)this.npc, this.owner.field_70170_p.field_73011_w.getDimension(), this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
                if (entity instanceof EntityNPCInterface) {
                    fs.dimId = entity.field_70170_p.field_73011_w.getDimension();
                    fs.id = entity.func_110124_au();
                    ((EntityNPCInterface)entity).func_70661_as().func_75497_a((Entity)this.owner, this.npc.ais.canSprint ? 1.3 : 1.0);
                }
            }
            catch (CommandException e) {
                LogWriter.error((Object)e);
            }
        } else {
            if (dist <= 2.5) {
                if (!this.npc.func_70661_as().func_75500_f()) {
                    this.npc.func_70661_as().func_75499_g();
                }
                return false;
            }
            if (dist > (double)this.getRange()) {
                this.npc.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
            } else {
                boolean bo = this.npc.func_70661_as().func_75497_a((Entity)this.owner, this.npc.ais.canSprint ? 1.3 : 1.0);
                if (!bo && !this.npc.isMoving()) {
                    if (this.waitTime == 0L) {
                        this.waitTime = 10L;
                        return false;
                    }
                    --this.waitTime;
                    if (this.waitTime <= 0L) {
                        this.npc.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
                    }
                } else {
                    this.waitTime = 0L;
                }
            }
        }
        return false;
    }

    @Override
    public boolean defendOwner() {
        return !this.isFollowing() || this.npc.advanced.jobInterface.getEnumType() != JobType.GUARD;
    }

    @Override
    public int getDays() {
        if (this.infiniteDays) {
            return 100;
        }
        if (this.daysHired <= 0) {
            return 0;
        }
        int daysPassed = (int)Math.floor((double)(System.currentTimeMillis() - this.hiredTime) / 480000.0);
        return this.daysHired - daysPassed;
    }

    @Override
    public IPlayer<?> getFollowing() {
        EntityPlayer owner = this.getOwner();
        if (owner != null) {
            return (IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)owner);
        }
        return null;
    }

    @Override
    public boolean getGuiDisabled() {
        return this.disableGui;
    }

    @Override
    public boolean getInfinite() {
        return this.infiniteDays;
    }

    public EntityPlayer getOwner() {
        if (this.ownerUUID == null || this.ownerUUID.isEmpty()) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(this.ownerUUID);
            MinecraftServer server = null;
            if (this.npc.field_70170_p != null) {
                server = this.npc.field_70170_p.func_73046_m();
            }
            if (server == null && CustomNpcs.Server != null) {
                server = CustomNpcs.Server;
            }
            if (server != null) {
                return server.func_184103_al().func_177451_a(uuid);
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        assert (this.npc.field_70170_p != null);
        return this.npc.field_70170_p.func_72924_a(this.ownerUUID);
    }

    private PlayerData getOwnerData() {
        if (this.ownerUUID == null || this.ownerUUID.isEmpty() || CustomNpcs.Server == null || this.npc.field_70170_p == null || this.npc.field_70170_p.func_73046_m() == null) {
            return null;
        }
        return PlayerDataController.instance.getDataFromUsername(CustomNpcs.Server == null ? this.npc.field_70170_p.func_73046_m() : CustomNpcs.Server, this.ownerUUID);
    }

    public int getRange() {
        if (this.npc.stats.aggroRange > CustomNpcs.NpcNavRange) {
            return CustomNpcs.NpcNavRange;
        }
        return this.npc.stats.aggroRange;
    }

    @Override
    public boolean getRefuseSoulstone() {
        return this.refuseSoulStone;
    }

    public boolean hasOwner() {
        return (this.infiniteDays || this.daysHired > 0) && this.ownerUUID != null && !this.ownerUUID.isEmpty();
    }

    @Override
    public void interact(EntityPlayer player) {
        if (this.ownerUUID == null || this.ownerUUID.isEmpty()) {
            this.npc.say(player, this.npc.advanced.getInteractLine());
            if (!this.rentalItems.func_191420_l() || this.rentalMoney > 0) {
                NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerFollowerHire, this.npc, 0, 0, 0);
            }
        } else if (player == this.owner && !this.disableGui) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerFollower, this.npc, 1, 0, 0);
        }
    }

    @Override
    public boolean isFollowing() {
        return this.ownerUUID != null && !this.ownerUUID.isEmpty() && this.isFollowing && this.getDays() > 0;
    }

    @Override
    public void killed() {
        if (!this.inventory.func_191420_l()) {
            if (this.owner == null) {
                for (ItemStack stack : this.inventory.items) {
                    if (NoppesUtilServer.IsItemStackNull(stack) || stack.func_190926_b()) continue;
                    this.npc.func_70099_a(stack, 0.0f);
                }
            } else if (this.owner.field_70170_p.field_73011_w.getDimension() == this.npc.field_70170_p.field_73011_w.getDimension()) {
                for (ItemStack stack : this.inventory.items) {
                    if (NoppesUtilServer.IsItemStackNull(stack) || stack.func_190926_b()) continue;
                    EntityItem entityitem = new EntityItem(this.owner.field_70170_p, this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, stack);
                    entityitem.func_174867_a(0);
                    this.owner.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
            this.inventory.func_174888_l();
        }
        this.ownerUUID = null;
        this.daysHired = 0;
        this.hiredTime = 0L;
        this.isFollowing = true;
        PlayerData plData = this.getOwnerData();
        if (plData != null) {
            plData.game.removeFollower(this.npc);
            plData.save(true);
        }
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = RoleType.FOLLOWER;
        this.ownerUUID = compound.func_74779_i("MercenaryOwner");
        this.daysHired = compound.func_74762_e("MercenaryDaysHired");
        this.hiredTime = compound.func_74763_f("MercenaryHiredTime");
        this.dialogHire = compound.func_74779_i("MercenaryDialogHired");
        this.dialogFarewell = compound.func_74779_i("MercenaryDialogFarewell");
        if (compound.func_150297_b("MercenaryDialogFired", 8)) {
            this.dialogFired = compound.func_74779_i("MercenaryDialogFired");
        }
        this.rates = NBTTags.getIntegerIntegerMap(compound.func_150295_c("MercenaryDayRates", 10));
        this.rentalItems.load(compound.func_74775_l("MercenaryInv"));
        if (compound.func_150297_b("MercenaryInventory", 10)) {
            int size = compound.func_74775_l("MercenaryInventory").func_74762_e("NpcMiscInvSize");
            this.inventory = new NpcMiscInventory(size);
            this.inventory.load(compound.func_74775_l("MercenaryInventory"));
        }
        this.rentalMoney = compound.func_74762_e("MercenaryMoney");
        this.isFollowing = compound.func_74767_n("MercenaryIsFollowing");
        this.disableGui = compound.func_74767_n("MercenaryDisableGui");
        this.infiniteDays = compound.func_74767_n("MercenaryInfiniteDays");
        this.refuseSoulStone = compound.func_74767_n("MercenaryRefuseSoulstone");
    }

    @Override
    public void reset() {
        this.killed();
    }

    @Override
    public void setFollowing(IPlayer<?> player) {
        if (player == null) {
            this.ownerUUID = null;
        } else {
            this.setOwner((EntityPlayer)player.getMCEntity());
        }
    }

    @Override
    public void setGuiDisabled(boolean disabled) {
        this.disableGui = disabled;
    }

    @Override
    public void setInfinite(boolean infinite) {
        this.infiniteDays = infinite;
    }

    public void setOwner(EntityPlayer player) {
        UUID id = player.func_110124_au();
        if (this.ownerUUID == null || !this.ownerUUID.equals(id.toString())) {
            this.killed();
        }
        this.ownerUUID = id.toString();
    }

    @Override
    public void setRefuseSoulstone(boolean refuse) {
        this.refuseSoulStone = refuse;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        compound.func_74768_a("MercenaryDaysHired", this.daysHired);
        compound.func_74772_a("MercenaryHiredTime", this.hiredTime);
        compound.func_74778_a("MercenaryDialogHired", this.dialogHire);
        compound.func_74778_a("MercenaryDialogFarewell", this.dialogFarewell);
        compound.func_74778_a("MercenaryDialogFired", this.dialogFired);
        if (this.hasOwner()) {
            compound.func_74778_a("MercenaryOwner", this.ownerUUID);
        }
        compound.func_74782_a("MercenaryDayRates", (NBTBase)NBTTags.nbtIntegerIntegerMap(this.rates));
        compound.func_74782_a("MercenaryInv", (NBTBase)this.rentalItems.save());
        compound.func_74782_a("MercenaryInventory", (NBTBase)this.inventory.save());
        compound.func_74768_a("MercenaryMoney", this.rentalMoney);
        compound.func_74757_a("MercenaryIsFollowing", this.isFollowing);
        compound.func_74757_a("MercenaryDisableGui", this.disableGui);
        compound.func_74757_a("MercenaryInfiniteDays", this.infiniteDays);
        compound.func_74757_a("MercenaryRefuseSoulstone", this.refuseSoulStone);
        return compound;
    }
}

